/*GROWTH ACCOUNTING MODEL*/

/*Simple growth projection model.*/
/*INPUTS.. */
/*Preliminaries include.. File path, data, dimensions = XX YY*/

/*NOTE.. This will not run without inputs from the Population projection*/
/*model - because employment growth numbers are needed*/

/*Note that reg_emp_shares are in "fact" a mix of regional employment shares*/
/*and regional GDP shares */

/*DEVELOPMENTS REQUIRED.. Includes putting the employment and unemployment*/
/*numbers into this model - but leaving labour force in the demographic model.*/

/* DIMENSIONS - note the variable projection lengths, presently resolved*/
/* by adding and subtracting ones (most macro data is 2013 on, some is 2012 and ind MFP indices are 2011 as at July 2013) */

mata
/*DIMENSIONS*/
/*Projection length, periods*/
Ps = 2021
Pe = 2050
/*Projection_t = 2021:2050*/
/*Length of historical data series*/
Ts = 1992
Te = 2020
/*Set population series length, history plus projection*/
/*Time_t = 1992:2050*/
Time_length = Pe - Ts + 1
TL = Time_length

/*Length of history*/
/*History_length = length(History_t)*/
History_length = Te - Ts+1
HL = History_length

/*Length of projection*/
/*Projection_length = length(Projection_t) */
Projection_length = Pe - Ps + 1

/*Last year for which census HH income data available*/
LastCensusYear = 2020

/*Industries Includes (Ind) and excludes (Indx) Unallocated*/

/* set number of regions*/
/*Reg_n = 1:12*/
Regl = 12
/*Reg_str = ['NOR''AKL''WAI''BOP''TAR''MAN''WEL''CAN''OTG''STH''GIS''USI'] */
/*Industries*/
Ind = 1..17 
Ind_n = 17
Indx = 1..16 
Indx_n = 16
/*Regions*/
Regions = 1..12
Regions_n = length(Regions)
/*HH income series lengths*/
/*HH Inc History length*/
HHinc_StartYear = 1998
HH_start = HHinc_StartYear-Ts+1
HHhist = History_length-HH_start+1 

/* PARAMETERS/ASSUMPTIONS*/
/*[1) HH income growth relative to overall GDP*/
/* Impacts of GDE growth per working age person (inc_beta) and average age*/
/* of household (age_beta) estimated in a panel of HH income. */
/*Note that the parameters are from an HLFS data series excluding people over 64 */
/*and as a consequence single person households (alon) are assumed to grow 1..1 with GDP per working age person. */
/*A reasonable alternative to the below parameters would be to assume that*/
/*incomes grow in line with growth in GDE per woking age person. */
/*Empirical/econometric modelling could not conclusively reject that*/
/*hypothesis. */
age_beta = 1.034641592
alon_inc_beta =	1.164407279
cple_inc_beta =	1.348635072
mult_inc_beta = 0.832854279
multif_inc_beta = 0.749259168
onep_inc_beta =	0.874550453
twop_inc_beta =	1.096184261

mult_inc_beta = mult_inc_beta*hh_inc_shk
multif_inc_beta = multif_inc_beta*hh_inc_shk
onep_inc_beta =	onep_inc_beta*hh_inc_shk

/*Vector of industry output shocks (populated individually in HHandRegions.m) */
ind_vol_shr_shock_v = (ag_shock,	othp_shock,	man_shock,	con_shock,	whl_shock,	rtl_shock,	afb_shock,	trn_shock,	fin_shock,	rent_shock,	ood_shock, prof_shock,	pub_shock,	edu_shock,	hlth_shock,	oths_shock)


/*Populate matrix of time dependent industry share shocks*/
ind_vol_shr_shock_m = J(Time_length, Indx_n,0)
/*
ind_vol_shr_shock_m[ag_shock_t,1] = ag_shock
ind_vol_shr_shock_m[othp_shock_t] = othp_shock
ind_vol_shr_shock_m[man_shock_t,3] = man_shock
ind_vol_shr_shock_m[con_shock_t,4] = con_shock
ind_vol_shr_shock_m[whl_shock_t,5] = whl_shock
ind_vol_shr_shock_m[rtl_shock_t,6] = rtl_shock
ind_vol_shr_shock_m[afb_shock_t,7] = afb_shock
ind_vol_shr_shock_m[trn_shock_t,8] = trn_shock
ind_vol_shr_shock_m[fin_shock_t,9] = fin_shock
ind_vol_shr_shock_m[rent_shock_t,10] = rent_shock
ind_vol_shr_shock_m[ood_shock_t,11] = ood_shock
ind_vol_shr_shock_m[prof_shock_t,12] = prof_shock
ind_vol_shr_shock_m[pub_shock_t,13] = pub_shock
ind_vol_shr_shock_m[edu_shock_t,14] = edu_shock
ind_vol_shr_shock_m[hlth_shock_t,15] = hlth_shock
ind_vol_shr_shock_m[oths_shock_t,16] = oths_shock
*/

/*MFP growth(populated individually in NLTDM.m) */
ind_mfp_assumption = (ag_mfp,	othp_mfp,	man_mfp,	con_mfp,	whl_mfp,	rtl_mfp,	afb_mfp,	trn_mfp,	fin_mfp,	rent_mfp,	ood_mfp,	prof_mfp,	pub_mfp,	edu_mfp,	hlth_mfp,	oths_mfp)

/* INITIALISE*/
/*Create empty sets for projections consisting of history and projectional*/
/*length zeros*/

/*(i) Macro variables*/
/*Note projection/history length adjustment (PLA) */

l_input_fcast = (l_input\ J(Projection_length,1,0))
k_input_fcast = (k_input\ J(Projection_length,1,0))
lbr_inc_share_fcast = (lbr_inc_shr\ J(Projection_length,1,0))
k_inc_share_fcast = (k_inc_shr\ J(Projection_length,1,0))
gdp_vol_fcast = (gdp_vol\ J(Projection_length,1,0)) 
mfp_index_fcast = (mfp_index\ J(Projection_length,1,0))
mfp_e = rnormal(TL,1,0,tot_mfp_stdev)
l_input_growth = J(Time_length,1,0)
k_input_growth = J(Time_length,1,0)
mfp_growth = J(Time_length,1,0)
gdp_growth = J(Time_length,1,0)
gdp_percapita_growth = J(Time_length,1,0)
gdp_per_workage_growth = J(Time_length,1,0)
ind_mfp_index_fcast = (ind_mfp_index\J(Projection_length,Indx_n,0)) 
ind_mfp_growth = J(Time_length,Indx_n,0)

/*GDP industry VAR*/
ind_vol_exog = J(Time_length,Ind_n,0)
/*NOTE that the previous version used dlog(vol) rather than dlog(vol_shr)*/

ind_vol_exog_shr = gdp_ind_vol[1..History_length,1..Indx_n]:/J(1,Indx_n,rowsum(gdp_ind_vol[1..History_length,1..Indx_n]))


/*Previous version 
ind_vol_exog(2..History_length,1..Indx_n) = diff(log(gdp_ind_vol[1..History_length,1..Indx_n))]*/ /*PLA*/
ind_vol_exog[2..History_length,1..Indx_n] = diff(log(ind_vol_exog_shr[1..History_length,1..Indx_n]))
ind_vol_exog[1..Time_length,Ind_n] = J(Time_length,1,1)
gdp_ind_vol_fcast_fit = ind_vol_exog


/* (ii) HH incomes*/
alon_inc = J(Time_length,1,0)
cple_inc = J(Time_length,1,0)
mult_inc = J(Time_length,1,0)
multif_inc = J(Time_length,1,0)
onep_inc = J(Time_length,1,0)
twop_inc = J(Time_length,1,0)
nz_hh_inc_growth = J(Time_length,1,0)

/*(iii) Regional HH incomes*/
alon_inc_reg = J(Time_length, Regions_n, 0)
cple_inc_reg = J(Time_length, Regions_n,0)
mult_inc_reg = J(Time_length, Regions_n,0)
multif_inc_reg = J(Time_length, Regions_n,0)
onep_inc_reg = J(Time_length, Regions_n,0)
twop_inc_reg = J(Time_length, Regions_n,0)
reg_hh_inc_growth = J(Time_length, Regions_n,0)


/*(iv) Historical employment and GDP (ind) shares */
emp_shr_nor = reg_emp_shr_data[1..Indx_n,.]
emp_shr_akl = reg_emp_shr_data[Indx_n*2-Indx_n+1..Indx_n*2,.]
emp_shr_wai = reg_emp_shr_data[Indx_n*3-Indx_n+1..Indx_n*3,.]
emp_shr_bop = reg_emp_shr_data[Indx_n*4-Indx_n+1..Indx_n*4,.]
emp_shr_tar = reg_emp_shr_data[Indx_n*5-Indx_n+1..Indx_n*5,.]
emp_shr_man = reg_emp_shr_data[Indx_n*6-Indx_n+1..Indx_n*6,.]
emp_shr_wel = reg_emp_shr_data[Indx_n*7-Indx_n+1..Indx_n*7,.]
emp_shr_can = reg_emp_shr_data[Indx_n*8-Indx_n+1..Indx_n*8,.]
emp_shr_otg = reg_emp_shr_data[Indx_n*9-Indx_n+1..Indx_n*9,.]
emp_shr_sth = reg_emp_shr_data[Indx_n*10-Indx_n+1..Indx_n*10,.]
emp_shr_gsi = reg_emp_shr_data[Indx_n*11-Indx_n+1..Indx_n*11,.]
emp_shr_usi = reg_emp_shr_data[Indx_n*12-Indx_n+1..Indx_n*12,.]

		emp_shr_all = (emp_shr_nor',emp_shr_akl',emp_shr_wai',emp_shr_bop',emp_shr_tar',emp_shr_man',emp_shr_wel',emp_shr_can',emp_shr_otg',emp_shr_sth',emp_shr_gsi',emp_shr_usi')
		reg_emp_shares = (emp_shr_all\J(Projection_length,Indx_n*Regions_n,0))
/*It is unclear if this is useful or if it will confuse model results. For the time being it is being ignored. */
reg_emp_shock = J(Time_length,Indx_n,Regions_n) 
/* 		reg_emp_dist = reg_emp_shares:/J(1, Indx_n,rowsum(reg_emp_shares)) */

reg_emp_dist =  shrcat(reg_emp_shares,Indx_n)

ind_shr_nor = reg_ind_shr_data[1..Indx_n,.]
ind_shr_akl = reg_ind_shr_data[Indx_n*2-Indx_n+1..Indx_n*2,.]
ind_shr_wai = reg_ind_shr_data[Indx_n*3-Indx_n+1..Indx_n*3,.]
ind_shr_bop = reg_ind_shr_data[Indx_n*4-Indx_n+1..Indx_n*4,.]
ind_shr_tar = reg_ind_shr_data[Indx_n*5-Indx_n+1..Indx_n*5,.]
ind_shr_man = reg_ind_shr_data[Indx_n*6-Indx_n+1..Indx_n*6,.]
ind_shr_wel = reg_ind_shr_data[Indx_n*7-Indx_n+1..Indx_n*7,.]
ind_shr_can = reg_ind_shr_data[Indx_n*8-Indx_n+1..Indx_n*8,.]
ind_shr_otg = reg_ind_shr_data[Indx_n*9-Indx_n+1..Indx_n*9,.]
ind_shr_sth = reg_ind_shr_data[Indx_n*10-Indx_n+1..Indx_n*10,.]
ind_shr_gsi = reg_ind_shr_data[Indx_n*11-Indx_n+1..Indx_n*11,.]
ind_shr_usi = reg_ind_shr_data[Indx_n*12-Indx_n+1..Indx_n*12,.]
		ind_shr_all = (ind_shr_nor',ind_shr_akl',ind_shr_wai',ind_shr_bop',ind_shr_tar',ind_shr_man',ind_shr_wel',ind_shr_can',ind_shr_otg',ind_shr_sth',ind_shr_gsi',ind_shr_usi')	
		reg_ind_shares = (ind_shr_all\J(Projection_length,Indx_n*Regions_n,0))
/*history of regional employment shares by industry with space for forecast entries*/
/*It is unclear if this is useful or if it will confuse model results. For the time being it is being ignored. */
/*reg_ind_shares:/J(1,Indx_n,rowsum(reg_ind_shares)) */
reg_ind_shock = J(Time_length,Indx_n*Regions_n,0) 
reg_ind_dist =  shrcat(reg_emp_shares,Indx_n)
		
/*(v) Regional GDP*/
		reg_ind_gdp = J(Time_length,Indx_n*Regions_n,0)
		reg_ind_gnp = J(Time_length,Indx_n*Regions_n,0)
		reg_ind_nom_gdp = J(Time_length,Indx_n*Regions_n,0)
/*PLA*/
gdp_ind_vol_fcast = (gdp_ind_vol\J(Projection_length,Ind_n,0))
gdp_ind_nom_fcast = (gdp_ind_nom\J(Projection_length,Ind_n,0))
gdp_ind_vol_shr_fcast = (gdp_ind_vol_shr\J(Projection_length,Ind_n,0))
gdp_ind_vol_shr_fcast_raw = (gdp_ind_vol_shr\J(Projection_length,Ind_n,0))
gdp_ind_nom_shr_fcast = (gdp_ind_nom_shr\J(Projection_length,Ind_n,0))
reg_gdp_growth = J(Time_length, Regions_n,0)
reg_gdp_per_workage_growth = J(Time_length, Regions_n,0)
		reg_ind_gdp_growth = J(Time_length,Indx_n*Regions_n,0)
reg_gnp_growth = J(Time_length, Regions_n,0)
reg_gnp_per_workage_growth = J(Time_length, Regions_n,0)
		reg_ind_gnp_growth = J(Time_length,Indx_n*Regions_n,0)
		reg_mfp_growth_by_ind = J(Time_length,Indx_n*Regions_n,0)
reg_mfp_growth = J(Time_length, Regions_n,0)




/* (A) PROJECT NATIONAL GROWTH*/

/*Note.. We assume a constant capital to labour ratio over projection*/
/*horizon - implying that we don't need to use income shares, however income*/
/*shares have been included to allow for changes to this simplistic*/
/*assumption*/

/*(A.1) Forecast levels of proximate determinants */
/*[For loop not per se necessary at this stage, until we want a stochastic*/
/*component] */
for (i=History_length; i<=Time_length; i++){
l_input_fcast[i,.] = l_input_fcast[i-1,.]*(1+employment_growth[i,.])
k_input_fcast[i,.] = k_input_fcast[i-1,.]*(1+employment_growth[i,.])
lbr_inc_share_fcast[i,.] = lbr_inc_share_fcast[i-1,.]*1
k_inc_share_fcast[i,.] = k_inc_share_fcast[i-1,.]*1
mfp_index_fcast[i,.] = mfp_index_fcast[i-1,.]:*((tot_mfp+mfp_cycle[i])+mfp_e[i,.])	
}


/*(A.2) Growth in proximate determinants chk = l_input_fcast(2..end):/l_input_fcast[1..end-1)-1*/

l_input_delta = diff(l_input_fcast)
k_input_delta = diff(k_input_fcast)
mfp_delta = diff(mfp_index_fcast)  
l_input_growth[2..rows(l_input_growth),.] =  l_input_fcast[2..rows(l_input_fcast)]:/l_input_fcast[1..rows(l_input_fcast)-1]:-1
k_input_growth[2..rows(k_input_growth),.] = k_input_fcast[2..rows(k_input_fcast)]:/k_input_fcast[1..rows(k_input_fcast)-1]:-1
mfp_growth[2..rows(mfp_growth),.] = mfp_index_fcast[2..rows(mfp_index_fcast)]:/mfp_index_fcast[1..rows(mfp_index_fcast)-1]:-1

/*(A.3)Growth in potential GDP*/
gdp_potential_growth = (lbr_inc_share_fcast:*l_input_growth)+ (k_inc_share_fcast:*k_input_growth) + mfp_growth

/*(A.4) Growth in GDP (volume) */
gdp_delta = diff(gdp_vol)
gdp_growth[2..History_length,.] = gdp_delta:/gdp_vol_fcast[1..History_length-1,.]   
gdp_growth[History_length+1..rows(gdp_growth),.]= gdp_potential_growth[History_length+1..rows(gdp_potential_growth),.] 



/*(A.5)GDP level and per capita GDP and GDP per working age person*/
for (i=History_length; i<=Time_length; i++){
gdp_vol_fcast[i,.] = gdp_vol_fcast[i-1,.]*(1:+gdp_growth[i,.])
}
gdp_percapita = gdp_vol_fcast:/pop
gdp_percapita_growth[2..rows(gdp_percapita_growth)] = diff(gdp_percapita):/gdp_percapita[1..Time_length-1,.]
gdp_per_workage = gdp_vol_fcast:/pop_workage
gdp_per_workage_growth[2..rows(gdp_per_workage_growth)] = diff(gdp_per_workage):/gdp_per_workage[1..Time_length-1,.]

/* (B) PROJECT REGIONAL GDP GROWTH*/

/*PROJECT INDUSTRY GDP (&SHARES) */
/*GDP volume aggregate, conveniently constructured from industry shares to avoid the usual adding up problems*/
/*GDP nominal aggregate, conveniently constructured from industry shares to avoid the usual adding up problems*/
gdp_vol_aggr = rowsum(gdp_ind_vol_fcast) 
gdp_nom_aggr = rowsum(gdp_ind_nom_fcast) 
for (i=History_length+1; i<=Time_length; i++){
    for (j=1; j<=Indx_n; j++){

        gdp_ind_vol_fcast_fit[i,j] = ind_vol_exog[i-1,.]*ind_vol_shr_coeffs[.,j]
		ind_vol_exog[i,j] = gdp_ind_vol_fcast_fit[i,j]
        gdp_ind_vol_fcast[i,j] = (gdp_ind_vol_fcast[i-1,j]*exp(gdp_ind_vol_fcast_fit[i,j])):*(1:+ind_vol_shr_shock_m[i,j])


    }


	reg_emp_dist[i,.]=reg_emp_dist[i-1,.]
	reg_ind_dist[i,.]=reg_ind_dist[i-1,.]
	reg_ind_shares[i,.]=reg_ind_shares[i-1,.]
    gdp_ind_vol_fcast[i,Ind_n] = gdp_ind_vol_fcast[i-1,Ind_n]:*(1:+gdp_growth[i,.])
    gdp_vol_aggr[i,.] = gdp_vol_aggr[i-1,.]:*(1:+gdp_growth[i,.])
}

/* Calibrate inputs for MBIE series */
gdp_mbie2250=(275926.5,281638,285968,293431,302170.5,310347.583753407,317972.297328358,325292.736714182,331959.925416336,337895.917057461,343578.9248304,349123.099372559,354522.473906317,359764.639263568,364861.342643139,369895.202226788,374927.160485782,379960.615732393,384984.048441462,389964.70743155,394881.713430456,399734.079535544,404527.473769773,409254.960708092,413899.865716559,418445.751088609,422890.7001567,427230.448055998,431441.446101028)'
gdp_ind_vol_fcast_sum = rowsum(gdp_ind_vol_fcast)
gdp_ind_vol_fcast_sh = gdp_ind_vol_fcast:/gdp_ind_vol_fcast_sum
gdp_ind_vol_fcast_agr = rowsum(gdp_ind_vol_fcast[1..30,.])
gdp_ind_vol_fcast_mb = gdp_ind_vol_fcast_sh[31..59,.]:*gdp_mbie2250[1..29]
gdp_ind_vol_fcast_ratio = rowsum(gdp_ind_vol_fcast_mb[1,.])/gdp_ind_vol_fcast_sum[31]
gdp_ind_vol_fcast_hist_cal = gdp_ind_vol_fcast:*gdp_ind_vol_fcast_ratio
gdp_ind_vol_fcast_cal = (gdp_ind_vol_fcast_hist_cal[1..30,.]\gdp_ind_vol_fcast_mb)
gdp_ind_vol_fcast_old = gdp_ind_vol_fcast
gdp20_smoothing = (gdp_ind_vol_fcast_sum[28]+gdp_ind_vol_fcast_sum[29])/2
gdp21_smoothing = (gdp20_smoothing+gdp_mbie2250[1])/2
gdp_ind_vol_fcast_sum_cal = (gdp_ind_vol_fcast[1..28]\gdp20_smoothing\gdp21_smoothing\gdp_mbie2250)
gdp_ind_vol_fcast = gdp_ind_vol_fcast_sh:*gdp_ind_vol_fcast_sum_cal

/* Calculate employment by industry via industry shares*/
/* NOTE.. REG_EMPLOYMENT below should be ind_employment OR reg_emp_dist needs*/
/* to be revised to be within region employment shares. */
/* NEED to check that this is not a problem for the GDP numbers too. */

/*Calculate GDP shares - to ensure that industry GDP does not exceed*/
/*the National GDP figure*/
/*[i) Calculate GDP shares - */
/* (a) on raw model values - which has sharp corrections in the near term*/
for (i=History_length; i<=Time_length; i++){
    gdp_ind_vol_shr_fcast_raw[i,1..Ind_n] =  gdp_ind_vol_fcast[i,1..Ind_n]:/rowsum(gdp_ind_vol_fcast[i,1..Ind_n])
}
/* (b) smoothed value based on 4 yr MA*/
for (i=History_length; i<=Time_length; i++){
    gdp_ind_vol_shr_fcast[i,1..Ind_n] =  J(1,Ind_n,mean(gdp_ind_vol_shr_fcast_raw[i,.]'))
}
/*[ii) allocate shares against the GDP aggregate*/
for (i=1; i<=Ind_n; i++){
gdp_ind_vol_fcast[History_length+1..rows(gdp_ind_vol_fcast),i] = gdp_ind_vol_shr_fcast[History_length+1..rows(gdp_ind_vol_shr_fcast),i]:*gdp_vol_aggr[History_length+1..rows(gdp_vol_aggr),.]
}
/*[iii) Backcast and forecast employment counts*/
emp_by_ind_nzl_fcast = (J(8,Indx_n,0)\emp_by_ind_nzl\J(Projection_length,Indx_n,0))
for (i = 1; i<=(2000-1992);i++){
	emp_by_ind_nzl_fcast[9-i,.] = (gdp_ind_vol_fcast[9-i,1..Indx_n]:/gdp_ind_vol_fcast[10-i,1..Indx_n]):*emp_by_ind_nzl_fcast[10-i,.]
}
for (i = History_length+1; i<Time_length; i++){
	emp_by_ind_nzl_fcast[i,.] = (gdp_ind_vol_fcast[i,1..Indx_n]:/gdp_ind_vol_fcast[i-1,1..Indx_n]):*emp_by_ind_nzl_fcast[i-1,.]
}


/*[iv) Find regional employment counts using regional shares of national industry and national levels*/
/* by industry */
reg_emp_by_ind = reg_ind_shares:*J(1,Regl,emp_by_ind_nzl_fcast)

/*reg_emp_by_ind = reshape(permute(reg_emp_dist,[1 3 2]),59*12,[]):*repmat(emp_by_ind_nzl_fcast,Regl,1]*/
/*(v) Calculate shares of industries within a regions*/
reg_emp_dist_in_reg = shrcat(reg_emp_by_ind,Indx_n) 
/*(v) scale the shares to employment values rather than counts*/

for (i=1; i<=Time_length; i++){
	for (j=1; j<=12; j++){
	reg_emp_by_ind[i,(Indx_n*(j-1)+1)..Indx_n*j] = reg_employment[i,j]:*reg_emp_dist_in_reg[i,(Indx_n*(j-1)+1)..Indx_n*j]
	}
}


/*Regional employment in levels*/
/*clearvars reg_emp_by_ind*/
/*reg_emp_by_ind = reg_emp_shares*/
/*Regional shares of employment*/
/*reg_emp_shares[1..TL,..,.] = reg_emp_by_ind[1..TL,..,.]:/repmat(rowsum(reg_emp_shares[1..TL,..,.],3),[1 1 12]] */
/*THIS NEEDS ANOTHER LOOK TO RESTORE THE GNP NUMBERS*/
reg_emp_shares = reg_ind_shares
/*ESTIMATE AND PROJECT REGIONAL GDP and employment based "GNP"*/
for (i=1; i<=Regl; i++){
	reg_ind_gnp[.,((Indx_n*(i-1)+1)..Indx_n*i)] = reg_emp_shares[.,((Indx_n*(i-1)+1)..Indx_n*i)]:*gdp_ind_vol_fcast[.,1..Indx_n]
	reg_ind_gdp[.,((Indx_n*(i-1)+1)..Indx_n*i)] = reg_ind_shares[.,((Indx_n*(i-1)+1)..Indx_n*i)]:*gdp_ind_vol_fcast[.,1..Indx_n]
}


reg_gnp = sumcat(reg_ind_gnp,Indx_n)
reg_gnp_growth[2..rows(reg_gnp_growth),.] = diff(reg_gnp):/reg_gnp[1..Time_length-1,.]
reg_gnp_per_workage = reg_gnp:/workage_pop_by_reg
reg_gnp_per_capita = reg_gnp:/pop_by_reg
reg_gnp_per_workage_growth[2..rows(reg_gnp_per_workage_growth),.] = diff(reg_gnp_per_workage):/reg_gnp_per_workage[1..Time_length-1,.]

reg_gdp = sumcat(reg_ind_gdp,Indx_n)


/*Check GDP aggregate and enforce adding up constraint*/
reg_gdp_aggr = rowsum(reg_gdp)
scale_reg_gdp = gdp_vol_fcast:/reg_gdp_aggr

for (i = 1; i<=Time_length; i++){
	reg_ind_gdp[i,.] = reg_ind_gdp[i,.]:*scale_reg_gdp[i]
}

reg_gdp = sumcat(reg_ind_gdp,Indx_n)

reg_gdp_growth[2..rows(reg_gdp_growth),.] = diff(reg_gdp):/reg_gdp[1..Time_length-1,.]
reg_gdp_per_workage = reg_gdp:/workage_pop_by_reg
reg_gdp_per_capita = reg_gdp:/pop_by_reg
reg_gdp_per_workage_growth[2..rows(reg_gdp_per_workage_growth),.] = diff(reg_gdp_per_workage):/reg_gdp_per_workage[1..Time_length-1,.]

/*Project industry labour demand*/
reg_ind_gdp_growth[2..rows(reg_ind_gdp_growth),.] = diff(reg_ind_gdp):/reg_ind_gdp[1..Time_length-1,.] 

/* Rethink the :+ below*/
for (i=HL; i<=TL; i++){
    ind_mfp_index_fcast[i,.] = ind_mfp_index_fcast[i-1,.]:*(ind_mfp_assumption :+ mfp_e[i])
}

ind_mfp_growth[2..rows(ind_mfp_growth),.] =  diff(ind_mfp_index_fcast):/ind_mfp_index_fcast[1..Time_length-1,.]
ind_mfp_growth_by_reg = J(1,Regl, ind_mfp_growth)

for (i=1; i<=Regl; i++){
	reg_mfp_growth_by_ind[.,((Indx_n*(i-1)+1)..Indx_n*i)] = reg_ind_shares[.,((Indx_n*(i-1)+1)..Indx_n*i)]:*ind_mfp_growth_by_reg[.,((Indx_n*(i-1)+1)..Indx_n*i)]
}
reg_mfp_growth = sumcat(reg_mfp_growth_by_ind,Indx_n) 
reg_emp_demand_growth = reg_gdp_growth - reg_mfp_growth
reg_labour_demand = reg_employment
for (i=HL; i<=TL; i++){
    reg_labour_demand[i,.] = reg_labour_demand[i,.]:*(1:+reg_emp_demand_growth[i,.])
}
reg_labour_gap = reg_labour_demand - reg_employment

/* (C) PROJECT NATIONAL HH INCOME*/

/*First year data from last census -- projections begin from there*/
alon_inc[HH_start..History_length,.] = hh_inc_input[.,1]
cple_inc[HH_start..History_length,.] = hh_inc_input[.,2]
mult_inc[HH_start..History_length,.] = hh_inc_input[.,3]
multif_inc[HH_start..History_length,.] = hh_inc_input[.,4]
onep_inc[HH_start..History_length,.] = hh_inc_input[.,5]
twop_inc[HH_start..History_length,.] = hh_inc_input[.,6]
nz_hh_inc_by_hh = (alon_inc,cple_inc,mult_inc,multif_inc, onep_inc,twop_inc)
nz_hh_inc = rowsum(hh_shares:*nz_hh_inc_by_hh)


/*Project each year based on parameters assigned earlier*/
for (i=History_length; i<=(Time_length-1); i++){
    alon_inc[i+1,.] = alon_inc[i,.]*(1:+(gdp_per_workage_growth[i+1,.]*alon_inc_beta)+(alon_age_growth[i+1]*age_beta))
    cple_inc[i+1,.] = cple_inc[i,.]*(1:+(gdp_per_workage_growth[i+1,.]*cple_inc_beta)+(cple_age_growth[i+1]*age_beta))
    mult_inc[i+1,.] = mult_inc[i,.]*(1:+(gdp_per_workage_growth[i+1,.]*mult_inc_beta)+(mult_age_growth[i+1]*age_beta))
    multif_inc[i+1,.] = multif_inc[i,.]*(1:+(gdp_per_workage_growth[i+1,.]*multif_inc_beta)+(multif_age_growth[i+1]*age_beta))
    onep_inc[i+1,.] = onep_inc[i,.]*(1:+(gdp_per_workage_growth[i+1,.]*onep_inc_beta)+(onep_age_growth[i+1]*age_beta))
    twop_inc[i+1,.] = twop_inc[i,.]*(1:+(gdp_per_workage_growth[i+1,.]*twop_inc_beta)+(twop_age_growth[i+1]*age_beta))
}

nz_hh_ave_inc = (alon_inc,onep_inc,twop_inc,multif_inc,mult_inc, cple_inc)
nz_hh_inc_tot = hh_composition:*nz_hh_ave_inc
nz_hh_inc_ave = rowsum(nz_hh_inc_tot):/households
nz_hh_inc_growth[2..rows(nz_hh_inc_growth)] = diff(nz_hh_inc_ave):/nz_hh_inc_ave[1..Time_length-1]

/* (D) PROJECT REGIONAL HH INCOME*/
alon_inc_reg[HH_start..History_length,.] = reg_hh_inc_input[1..HHhist,.]
cple_inc_reg[HH_start..History_length,.] = reg_hh_inc_input[2*HHhist-HHhist+1..2*HHhist,.]
mult_inc_reg[HH_start..History_length,.] = reg_hh_inc_input[3*HHhist-HHhist+1..3*HHhist,.]
multif_inc_reg[HH_start..History_length,.] = reg_hh_inc_input[4*HHhist-HHhist+1..4*HHhist,.]
onep_inc_reg[HH_start..History_length,.] = reg_hh_inc_input[5*HHhist-HHhist+1..5*HHhist,.]
twop_inc_reg[HH_start..History_length,.] = reg_hh_inc_input[6*HHhist-HHhist+1..6*HHhist,.]


/*Project each year based on paramaters assigned earlier*/
for (i=History_length; i<=Time_length-1; i++){
    alon_inc_reg[i+1,.] = alon_inc_reg[i,.]:*(1:+(reg_gdp_per_workage_growth[i+1,.]*alon_inc_beta):+(alon_age_growth[i+1]*age_beta))
    cple_inc_reg[i+1,.] = cple_inc_reg[i,.]:*(1:+(reg_gdp_per_workage_growth[i+1,.]*cple_inc_beta):+(cple_age_growth[i+1]*age_beta))
    mult_inc_reg[i+1,.] = mult_inc_reg[i,.]:*(1:+(reg_gdp_per_workage_growth[i+1,.]*mult_inc_beta):+(mult_age_growth[i+1]*age_beta))
    multif_inc_reg[i+1,.] = multif_inc[i,.]:*(1:+(reg_gdp_per_workage_growth[i+1,.]*multif_inc_beta):+(multif_age_growth[i+1]*age_beta))
    onep_inc_reg[i+1,.] = onep_inc_reg[i,.]:*(1:+(reg_gdp_per_workage_growth[i+1,.]*onep_inc_beta):+(onep_age_growth[i+1]*age_beta))
    twop_inc_reg[i+1,.] = twop_inc_reg[i,.]:*(1:+(reg_gdp_per_workage_growth[i+1,.]*twop_inc_beta):+(twop_age_growth[i+1]*age_beta))
}

/*Calculate region HH income aggregates*/
alon_reg_shr = alon_reg:/reg_households
cple_reg_shr = cple_reg:/reg_households
mult_reg_shr = multi_reg:/reg_households
multif_reg_shr = multif_reg:/reg_households
onep_reg_shr = onep_reg:/reg_households
twop_reg_shr = twop_reg:/reg_households

/*hh income weighted by share of type in number of hh in a region*/
alon_incw_reg = alon_reg_shr:*alon_inc_reg 
cple_incw_reg = cple_reg_shr:*cple_inc_reg
mult_incw_reg = mult_reg_shr:*mult_inc_reg
multif_incw_reg = multif_reg_shr:*multif_inc_reg
onep_incw_reg = onep_reg_shr:*onep_inc_reg
twop_incw_reg = twop_reg_shr:*twop_inc_reg

hh_inc_reg = alon_incw_reg + cple_incw_reg + mult_incw_reg + multif_incw_reg + onep_incw_reg + twop_incw_reg

/* Collect regional values by HH*/
			reg_hh_ave_inc = (alon_inc_reg,onep_inc_reg, twop_inc_reg,multif_inc_reg,mult_inc_reg,cple_inc_reg)
	
	nor_hh_ave_inc = J(Time_length, 6, 0)
    akl_hh_ave_inc = J(Time_length, 6, 0)
    wai_hh_ave_inc = J(Time_length, 6, 0)
    bop_hh_ave_inc = J(Time_length, 6, 0)
    tar_hh_ave_inc = J(Time_length, 6, 0)
    man_hh_ave_inc = J(Time_length, 6, 0)
    wel_hh_ave_inc = J(Time_length, 6, 0)
    can_hh_ave_inc = J(Time_length, 6, 0)
    otg_hh_ave_inc = J(Time_length, 6, 0)
    sth_hh_ave_inc = J(Time_length, 6, 0)
    gis_hh_ave_inc = J(Time_length, 6, 0)
    usi_hh_ave_inc = J(Time_length, 6, 0)

			
for (j=1; j<=6; j++){
    nor_hh_ave_inc[.,j] = reg_hh_ave_inc[.,(12*(j-1)+1)]
    akl_hh_ave_inc[.,j] = reg_hh_ave_inc[.,(12*(j-1)+2)]
    wai_hh_ave_inc[.,j] = reg_hh_ave_inc[.,(12*(j-1)+3)]
    bop_hh_ave_inc[.,j] = reg_hh_ave_inc[.,(12*(j-1)+4)]
    tar_hh_ave_inc[.,j] = reg_hh_ave_inc[.,(12*(j-1)+5)]
    man_hh_ave_inc[.,j] = reg_hh_ave_inc[.,(12*(j-1)+6)]
    wel_hh_ave_inc[.,j] = reg_hh_ave_inc[.,(12*(j-1)+7)]
    can_hh_ave_inc[.,j] = reg_hh_ave_inc[.,(12*(j-1)+8)]
    otg_hh_ave_inc[.,j] = reg_hh_ave_inc[.,(12*(j-1)+9)]
    sth_hh_ave_inc[.,j] = reg_hh_ave_inc[.,(12*(j-1)+10)]
    gis_hh_ave_inc[.,j] = reg_hh_ave_inc[.,(12*(j-1)+11)]
    usi_hh_ave_inc[.,j] = reg_hh_ave_inc[.,(12*(j-1)+12)]
}

/* Total HH income by region*/
nor_hh_inc_tot = nor_hh_composition:*nor_hh_ave_inc
akl_hh_inc_tot = akl_hh_composition:*akl_hh_ave_inc
wai_hh_inc_tot = wai_hh_composition:*wai_hh_ave_inc
bop_hh_inc_tot = bop_hh_composition:*bop_hh_ave_inc
tar_hh_inc_tot = tar_hh_composition:*tar_hh_ave_inc
man_hh_inc_tot = man_hh_composition:*man_hh_ave_inc
wel_hh_inc_tot = wel_hh_composition:*wel_hh_ave_inc
can_hh_inc_tot = can_hh_composition:*can_hh_ave_inc
otg_hh_inc_tot = otg_hh_composition:*otg_hh_ave_inc
sth_hh_inc_tot = sth_hh_composition:*sth_hh_ave_inc
gis_hh_inc_tot = gis_hh_composition:*gis_hh_ave_inc
usi_hh_inc_tot = usi_hh_composition:*usi_hh_ave_inc

/* Average HH income by region*/
nor_hh_inc_ave = rowsum(nor_hh_inc_tot):/nor_households
akl_hh_inc_ave = rowsum(akl_hh_inc_tot):/akl_households
wai_hh_inc_ave = rowsum(wai_hh_inc_tot):/wai_households
bop_hh_inc_ave = rowsum(bop_hh_inc_tot):/bop_households
tar_hh_inc_ave = rowsum(tar_hh_inc_tot):/tar_households
man_hh_inc_ave = rowsum(man_hh_inc_tot):/man_households
wel_hh_inc_ave = rowsum(wel_hh_inc_tot):/wel_households
can_hh_inc_ave = rowsum(can_hh_inc_tot):/can_households
otg_hh_inc_ave = rowsum(otg_hh_inc_tot):/otg_households
sth_hh_inc_ave = rowsum(sth_hh_inc_tot):/sth_households
gis_hh_inc_ave = rowsum(gis_hh_inc_tot):/gis_households
usi_hh_inc_ave = rowsum(usi_hh_inc_tot):/usi_households

/* Collect regional values*/
reg_hh_inc_ave = (nor_hh_inc_ave, akl_hh_inc_ave,wai_hh_inc_ave,bop_hh_inc_ave,tar_hh_inc_ave,man_hh_inc_ave,wel_hh_inc_ave,can_hh_inc_ave,otg_hh_inc_ave,sth_hh_inc_ave,gis_hh_inc_ave,usi_hh_inc_ave)
reg_hh_inc_growth[16..rows(reg_hh_inc_growth),.] = diff(reg_hh_inc_ave[15..Time_length,.]):/reg_hh_inc_ave[15..Time_length-1,.]


end

